# Overview

Author : Jaehyeok Bae (jhbae110@stanford.edu)

This repository contains two projects: `default_diffusion_project` and `fourier_compressed_sensing_project`. Below is a brief overview of each project and instructions on how to set up the conda environment using the provided YAML file.

## Projects

### 1. Default Diffusion Project

This project focuses on the implementation and analysis of diffusion processes. It includes various algorithms and simulations to study the behavior of diffusion in different scenarios.

For more details, please refer to the [README.md](default_diffusion_project/README.md) inside the `default_diffusion_project` folder.

### 2. Fourier Compressed Sensing Project

The Fourier Compressed Sensing Project explores the application of Diffusion Posterior Sampling in Fourier compressed sensing problem. It aims to reconstruct signals from a limited number of measurements in Fourier domain using a pretrained diffusion model.

For more details, please refer to the [README.md](fourier_compressed_sensing_project/README.md) inside the `fourier_compressed_sensing_project` folder.

## Setting Up Conda Environment

To create the conda environment for these projects, use the provided YAML file. Follow the steps below:

1. Open a terminal.
2. Navigate to the directory containing the `environments.yml` file.
3. Run the following command:

    ```sh
    conda env create -f environment.yml
    ```

4. The default name of conda environment is `ee367-project`.

Replace `<environment_name>` with the name specified in the `environments.yml` file.

## Contact
For questions or inquiries, contact Jaehyeok Bae at jhbae110@stanford.edu.
